<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// Ambil konfigurasi dan koneksi
require __DIR__ . '/../private/config.php';
// pastikan path ini sesuai dengan lokasi file kamu
require 'db.php';

// Validasi API key dari URL
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode([
        "success" => false,
        "message" => "Unauthorized access. API key invalid!"
    ]);
    exit;
}

// Ambil body JSON dari request
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

// Jika data kosong atau format JSON salah
if (!$data) {
    echo json_encode(["success" => false, "message" => "Data kosong atau format JSON salah"]);
    exit;
}

// Fungsi aman untuk menghindari SQL Injection
function safe($koneksi, $value) {
    return mysqli_real_escape_string($koneksi, trim($value ?? ''));
}

// Ambil semua data dari JSON
$tanggal = safe($koneksi, $data['tanggal']);
$nama = safe($koneksi, $data['nama']);
$alamat_lengkap = safe($koneksi, $data['alamat_lengkap']);
$nomor_hp = safe($koneksi, $data['nomor_hp']);
$tanggal_pengambilan = safe($koneksi, $data['tanggal_pengambilan']);
$detail_alamat = safe($koneksi, $data['detail_alamat']);
$jenis_orderan = safe($koneksi, $data['jenis_orderan']);
$pembayaran = safe($koneksi, $data['pembayaran']);
$user_id = safe($koneksi, $data['user_id']);
$koordinat = safe($koneksi, $data['koordinat']);
$id_pesanan = safe($koneksi, $data['id_pesanan']);
$alamat_gmaps = safe($koneksi, $data['alamat_gmaps']);
$status = safe($koneksi, $data['status']);
$one_id = safe($koneksi, $data['one_id']);
$harga = safe($koneksi, $data['harga']);
$delivery = safe($koneksi, $data['delivery']);
$foto = safe($koneksi, $data['foto']);
$bukti = safe($koneksi, $data['bukti']);
$penerima = safe($koneksi, $data['penerima']);
$bayar = safe($koneksi, $data['bayar']);
$feedback = safe($koneksi, $data['feedback']);
$berat = safe($koneksi, $data['berat']);
$tanggal_selesai = safe($koneksi, $data['tanggal_selesai']);
$layanan = safe($koneksi, $data['layanan']);

// Query Insert
$query = "INSERT INTO orders (
    tanggal, nama, alamat_lengkap, nomor_hp, tanggal_pengambilan, 
    detail_alamat, jenis_orderan, pembayaran, user_id, koordinat, id_pesanan, 
    alamat_gmaps, status, one_id, harga, delivery, foto, bukti, penerima, bayar, 
    feedback, berat, tanggal_selesai, layanan
) VALUES (
    '$tanggal', '$nama', '$alamat_lengkap', '$nomor_hp', '$tanggal_pengambilan',
    '$detail_alamat', '$jenis_orderan', '$pembayaran', '$user_id', '$koordinat', '$id_pesanan',
    '$alamat_gmaps', '$status', '$one_id', '$harga', '$delivery', '$foto', '$bukti', '$penerima', '$bayar',
    '$feedback', '$berat', '$tanggal_selesai', '$layanan'
)";

// Jalankan query
if (mysqli_query($koneksi, $query)) {
    echo json_encode(["success" => true, "message" => "Data berhasil disimpan"]);
} else {
    echo json_encode(["success" => false, "message" => mysqli_error($koneksi)]);
}
?>
