<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require __DIR__ . '/../private/config.php';
require 'db.php';

// Validasi API key
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode([
        "success" => false,
        "message" => "Unauthorized access. API key invalid!"
    ]);
    exit;
}

// Ambil data dari body (POST JSON)
$input = json_decode(file_get_contents("php://input"), true);

// Validasi input
if (
    empty($input['no_nota']) ||
    empty($input['reaksi']) ||
    empty($input['komentar']) ||
    empty($input['kepuasan'])
) {
    echo json_encode([
        "success" => false,
        "message" => "Semua field wajib diisi: no_nota, reaksi, komentar, kepuasan"
    ]);
    exit;
}

// Escape data untuk keamanan
$no_nota   = mysqli_real_escape_string($koneksi, $input['no_nota']);
$reaksi    = mysqli_real_escape_string($koneksi, $input['reaksi']);
$komentar  = mysqli_real_escape_string($koneksi, $input['komentar']);
$kepuasan  = mysqli_real_escape_string($koneksi, $input['kepuasan']);

// Query insert data ke tabel feedback
$query = "INSERT INTO feedback (no_nota, reaksi, komentar, kepuasan, created_at)
          VALUES ('$no_nota', '$reaksi', '$komentar', '$kepuasan', NOW())";

if (mysqli_query($koneksi, $query)) {
    echo json_encode([
        "success" => true,
        "message" => "Feedback berhasil dikirim!",
        "data" => [
            "id_feedback" => mysqli_insert_id($koneksi),
            "no_nota" => $no_nota,
            "reaksi" => $reaksi,
            "komentar" => $komentar,
            "kepuasan" => $kepuasan
        ]
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Gagal menyimpan feedback: " . mysqli_error($koneksi)
    ]);
}
?>
