<?php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

require __DIR__ . '/../private/config.php';

$response = [];

if (!$koneksi) {
    $response = ["status" => "error", "msg" => "Koneksi database gagal"];
    echo json_encode($response);
    exit;
}

$user_id = $_GET['user_id'] ?? null;

if (!$user_id) {
    $response = ["status" => "error", "msg" => "user_id wajib diisi"];
    echo json_encode($response);
    exit;
}

$stmt = $koneksi->prepare("
    SELECT id, user_id, title, message, timestamp, is_sender, status, type
    FROM chat 
    WHERE user_id = ? 
    ORDER BY id ASC
");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$chats = [];
while ($row = $result->fetch_assoc()) {
    $row['is_sender'] = ($row['is_sender'] == 1); // ubah ke boolean
    $chats[] = $row;
}

$response = [
    "status" => "success",
    "msg" => empty($chats) ? "Belum ada chat" : "Chat ditemukan",
    "data" => $chats
];

ob_end_clean();
echo json_encode($response, JSON_PRETTY_PRINT);

$stmt->close();
$koneksi->close();
?>
