<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require __DIR__ . '/../private/config.php';
require 'db.php';

// Validasi API key
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode([
        "success" => false,
        "message" => "Unauthorized access. Invalid API key!"
    ]);
    exit;
}

// Ambil parameter type (promo / informasi / foto_slide)
$type = isset($_GET['type']) ? strtolower($_GET['type']) : null;

if (!$type) {
    echo json_encode([
        "success" => false,
        "message" => "Parameter 'type' wajib diisi (promo / informasi / foto_slide)"
    ]);
    exit;
}

// Tentukan query berdasarkan type
switch ($type) {
    case 'promo':
        $query = "SELECT id, foto, judul, keterangan FROM promo ORDER BY id DESC";
        break;
    case 'informasi':
        $query = "SELECT id, foto, judul, keterangan FROM informasi ORDER BY id DESC";
        break;
    case 'foto_slide':
        $query = "SELECT id, posisi, foto FROM foto_slide ORDER BY id DESC";
        break;
    default:
        echo json_encode([
            "success" => false,
            "message" => "Type tidak dikenal. Gunakan 'promo', 'informasi', atau 'foto_slide'."
        ]);
        exit;
}

// Jalankan query
$result = mysqli_query($koneksi, $query);

if (!$result) {
    echo json_encode([
        "success" => false,
        "message" => "Gagal mengambil data: " . mysqli_error($koneksi)
    ]);
    exit;
}

// Ambil data
$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    $data[] = $row;
}

// Output JSON — fix buat Kodular
$output = [
    "success" => true,
    "type" => $type,
    "total" => count($data),
    "data" => json_decode(json_encode($data)) // <— ini triknya biar Kodular baca sebagai list
];

echo json_encode($output, JSON_PRETTY_PRINT);
?>
