<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require __DIR__ . '/../private/config.php';
require 'db.php';

// Validasi API key
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode([
        "success" => false,
        "message" => "Unauthorized access. Invalid API key!"
    ]);
    exit;
}

// Filter user_id (opsional)
$user_id = isset($_GET['user_id']) ? mysqli_real_escape_string($koneksi, $_GET['user_id']) : null;

// Query dengan filter user_id opsional
$query = "SELECT * FROM orders";
if ($user_id) {
    $query .= " WHERE user_id = '$user_id'";
}
$query .= " ORDER BY id DESC";

// Jalankan query
$result = mysqli_query($koneksi, $query);

if (!$result) {
    echo json_encode([
        "success" => false,
        "message" => "Gagal mengambil data: " . mysqli_error($koneksi)
    ]);
    exit;
}

// Ambil data dan tambahkan local_id
$data = [];
$counter = 1;
while ($row = mysqli_fetch_assoc($result)) {
    $row['local_id'] = $counter++;
    $data[] = $row;
}

// Output JSON — format sama seperti get_data.php untuk Kodular
$output = [
    "success" => true,
    "type" => "orders",
    "total" => count($data),
    "data" => json_decode(json_encode($data)) // <— trik untuk Kodular
];

echo json_encode($output, JSON_PRETTY_PRINT);
?>