<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../private/config.php';

// === Cek API Key ===
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access. Invalid API key.']);
    exit;
}

// === Koneksi Database ===
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed.']);
    exit;
}

// === Ambil user_id ===
$user_id = $_GET['user_id'] ?? '';

if (empty($user_id)) {
    echo json_encode(['success' => false, 'message' => 'Parameter user_id wajib diisi.']);
    exit;
}

// === Query data pelanggan ===
$stmt = $conn->prepare("SELECT * FROM pelanggan WHERE user_id = ?");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(['success' => true, 'data' => $row]);
} else {
    echo json_encode(['success' => false, 'message' => 'Data pelanggan tidak ditemukan.']);
}

$stmt->close();
$conn->close();
?>
