<?php
header('Content-Type: application/json');

// === Include Config ===
require_once __DIR__ . '/../private/config.php';

// === Cek API Key ===
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access. Invalid API key.']);
    exit;
}

// === Koneksi Database ===
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

// === Ambil data JSON dari body ===
$data = json_decode(file_get_contents("php://input"), true);

$user_id            = $data['user_id'] ?? '';
$nama               = $data['nama'] ?? '';
$nomor_handphone    = $data['nomor_handphone'] ?? '';
$alamat_lengkap     = $data['alamat_lengkap'] ?? '';
$email              = $data['email'] ?? '';
$tanggal_daftar     = $data['tanggal_daftar'] ?? '';
$one_id             = $data['one_id'] ?? '';
$terakhir_online    = $data['terakhir_online'] ?? '';

// === Validasi minimal ===
if (empty($user_id) || empty($nama) || empty($email)) {
    echo json_encode(['success' => false, 'message' => 'Field wajib belum lengkap.']);
    exit;
}

// === Cek apakah user_id sudah ada ===
$cek = $conn->prepare("SELECT * FROM pelanggan WHERE user_id = ?");
$cek->bind_param("s", $user_id);
$cek->execute();
$result = $cek->get_result();

if ($result->num_rows > 0) {
    echo json_encode(['success' => false, 'message' => 'User sudah terdaftar.']);
    exit;
}

// === Insert ke database ===
$stmt = $conn->prepare("INSERT INTO pelanggan (user_id, nama, nomor_handphone, alamat_lengkap, email, tanggal_daftar, one_id, terakhir_online)
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssssss", $user_id, $nama, $nomor_handphone, $alamat_lengkap, $email, $tanggal_daftar, $one_id, $terakhir_online);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Pendaftaran berhasil disimpan.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Gagal menyimpan data: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
