<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

require __DIR__ . '/../private/config.php';

// Pastikan koneksi database aktif
if (!$koneksi) {
    echo json_encode([
        "status" => "error",
        "msg" => "Koneksi database gagal: " . mysqli_connect_error()
    ]);
    exit;
}

// Ambil JSON raw body
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

// Validasi JSON
if (!$data || !is_array($data)) {
    echo json_encode([
        "status" => "error",
        "msg" => "Format JSON tidak valid atau data kosong"
    ]);
    exit;
}

// Ambil data dari JSON body
$user_id   = $data['user_id']   ?? '';
$title     = $data['title']     ?? 'You';
$message   = $data['message']   ?? '';
$timestamp = $data['timestamp'] ?? time(); // pakai UNIX time
$is_sender = $data['is_sender'] ?? 'true';
$status    = $data['status']    ?? '1';

// Validasi data wajib
if (empty($user_id) || empty($message)) {
    echo json_encode([
        "status" => "error",
        "msg" => "user_id dan message wajib diisi"
    ]);
    exit;
}

// Konversi boolean string ke integer
$is_sender_value = ($is_sender === true || $is_sender === 'true') ? 1 : 0;
$type = 'text';

// Simpan pesan ke database
$stmt = $koneksi->prepare("INSERT INTO chat (user_id, title, message, timestamp, is_sender, status, type) VALUES (?, ?, ?, ?, ?, ?, ?)");
if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "msg" => "Prepare statement gagal: " . $koneksi->error
    ]);
    exit;
}

$stmt->bind_param("sssiiss", $user_id, $title, $message, $timestamp, $is_sender_value, $status, $type);
if (!$stmt->execute()) {
    echo json_encode([
        "status" => "error",
        "msg" => "Gagal kirim pesan: " . $stmt->error
    ]);
    exit;
}

// 🔔 Kirim notifikasi via OneSignal
$get_user = $koneksi->prepare("SELECT one_id FROM pelanggan WHERE id = ?");
$get_user->bind_param("s", $user_id);
$get_user->execute();
$result = $get_user->get_result();

if ($result && $row = $result->fetch_assoc()) {
    $one_id = $row['one_id'];

    if (!empty($one_id)) {
        $fields = [
            'app_id' => ONESIGNAL_APP_ID,
            'include_player_ids' => [$one_id],
            'headings' => ['en' => 'Pesan baru dari Admin'],
            'contents' => ['en' => $message],
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic ' . ONESIGNAL_REST_API_KEY
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        curl_exec($ch);
        curl_close($ch);
    }
}

// ✅ Output sukses
echo json_encode([
    "status" => "success",
    "msg" => "Pesan berhasil dikirim & notifikasi dikirim",
    "data" => [
        "id"        => $stmt->insert_id,
        "user_id"   => $user_id,
        "title"     => $title,
        "message"   => $message,
        "timestamp" => $timestamp,
        "is_sender" => $is_sender_value,
        "status"    => $status,
        "type"      => $type
    ]
], JSON_PRETTY_PRINT);

$stmt->close();
$koneksi->close();
?>
