<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require __DIR__ . '/../private/config.php';
require 'db.php';

// Validasi API key
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode(["success" => false, "message" => "Unauthorized API key"]);
    exit;
}

// Ambil JSON dari body
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// Cek data
if (!$data || !isset($data['id_pesanan'])) {
    echo json_encode(["success" => false, "message" => "Data tidak valid"]);
    exit;
}

$id_pesanan = mysqli_real_escape_string($koneksi, $data['id_pesanan']);
$feedback   = mysqli_real_escape_string($koneksi, $data['feedback'] ?? '');

// Query update
$query = "UPDATE orders SET feedback='$feedback' WHERE id_pesanan='$id_pesanan'";

if (mysqli_query($koneksi, $query)) {
    echo json_encode(["success" => true, "message" => "Feedback berhasil diperbarui"]);
} else {
    echo json_encode(["success" => false, "message" => "Gagal update: " . mysqli_error($koneksi)]);
}
?>
