<?php
header('Content-Type: application/json');

// === Include Config ===
require_once __DIR__ . '/../private/config.php';

// === Cek API Key ===
if (!isset($_GET['api_key']) || $_GET['api_key'] !== API_KEY) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access. Invalid API key.']);
    exit;
}

// === Ambil parameter user_id dari URL ===
$user_id = $_GET['user_id'] ?? '';

// === Koneksi ke Database ===
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

// === Ambil data dari POST ===
$data = json_decode(file_get_contents("php://input"), true);
$nama = $data['nama'] ?? '';
$nomor_handphone = $data['nomor_handphone'] ?? '';
$alamat_lengkap = $data['alamat_lengkap'] ?? '';
$terakhir_online = $data['terakhir_online'] ?? '';

// === Validasi ===
if (empty($user_id)) {
    echo json_encode(['success' => false, 'message' => 'User ID wajib diisi (dikirim lewat URL).']);
    exit;
}

// === Cek apakah user_id ada di database ===
$cek = $conn->prepare("SELECT user_id FROM pelanggan WHERE user_id = ?");
$cek->bind_param("s", $user_id);
$cek->execute();
$result = $cek->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'User tidak ditemukan.']);
    exit;
}

// === Update hanya kolom yang dikirim ===
$update_fields = [];
$params = [];
$types = "";

// nama
if (!empty($nama)) {
    $update_fields[] = "nama = ?";
    $params[] = $nama;
    $types .= "s";
}

// nomor handphone
if (!empty($nomor_handphone)) {
    $update_fields[] = "nomor_handphone = ?";
    $params[] = $nomor_handphone;
    $types .= "s";
}

// alamat lengkap
if (!empty($alamat_lengkap)) {
    $update_fields[] = "alamat_lengkap = ?";
    $params[] = $alamat_lengkap;
    $types .= "s";
}

// terakhir online
if (!empty($terakhir_online)) {
    $update_fields[] = "terakhir_online = ?";
    $params[] = $terakhir_online;
    $types .= "s";
}

if (empty($update_fields)) {
    echo json_encode(['success' => false, 'message' => 'Tidak ada data yang dikirim untuk diperbarui.']);
    exit;
}

// Tambahkan user_id di akhir untuk WHERE
$params[] = $user_id;
$types .= "s";

// === Susun query dinamis ===
$query = "UPDATE pelanggan SET " . implode(", ", $update_fields) . " WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);

// === Eksekusi query ===
if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Data pelanggan berhasil diperbarui.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Gagal memperbarui data: ' . $stmt->error]);
}

// === Tutup koneksi ===
$stmt->close();
$conn->close();
?>
